/*
 * guidance.h
 *
 *  Created on: Apr 8, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_GUIDANCE_H_
#define USER_CODE_GUIDANCE_H_

#define N_WAYPOINTS 15
#define WPT_THRESH 3

#define STICK_DEAD_ZONE 0.03
#define EXPO_CURVE 1.35
#define VEL_Z_DEAD_ZONE 0.1

#define AIL_MAX 2 // 1.90
#define AIL_MID 1.5 // 1.53
#define AIL_MIN 1 // 1.14
#define AIL_SC_HIGH 0.5/(AIL_MAX - AIL_MID)
#define AIL_SC_LOW 0.5/(AIL_MID - AIL_MIN)

#define ELE_MAX 2 // 1.92
#define ELE_MID 1.5 // 1.53
#define ELE_MIN 1 // 1.14
#define ELE_SC_HIGH 0.5/(ELE_MAX - ELE_MID)
#define ELE_SC_LOW 0.5/(ELE_MID - ELE_MIN)

#define RUD_MAX 2 // 1.91
#define RUD_MID 1.5 // 1.53
#define RUD_MIN 1 // 1.13
#define RUD_SC_HIGH 0.5/(RUD_MAX - RUD_MID)
#define RUD_SC_LOW 0.5/(RUD_MID - RUD_MIN)

#define THR_MAX 2 // 2.02
#define THR_MIN 1 // 1.14
#define THR_SC 1/(THR_MAX - THR_MIN)

#define GUIDANCE_ALT_ERR_LIM 1
#define GUIDANCE_ALT_GAIN 0.5
#define GUIDANCE_YAW_ERR_LIM PI/2
#define GUIDANCE_YAW_GAIN 1

#define RECEIVER_DEBUG 0

void reset_wpt_counter();
uint16 get_wpt_counter();
float32 get_dist_to_wpt();
float32 get_course_to_wpt();
float32 get_ail_cmd();
float32 get_ele_cmd();
float32 get_rud_cmd();
float32 get_thr_cmd();
void guidance_step();

#endif /* USER_CODE_GUIDANCE_H_ */
